import React, { Dispatch, SetStateAction } from "react";
import EditDiscountForm from "./EditDiscountForm";
import { discountType } from "@/@types/discount";

type DiscountUpdateModalProps = {
  setIsOpen: Dispatch<SetStateAction<boolean>>;
  discountData: discountType | null;
};

export default function DiscountUpdateModal({
  setIsOpen,
  discountData,
}: DiscountUpdateModalProps) {
  return (
    <div className="fixed inset-0 flex items-center justify-center mx-auto w-screen h-screen overflow-hidden animate-fadeIn">
      <div className="w-[350px] md:w-[600px] p-3 bg-light dark:bg-dark-400 rounded-10 z-50">
        <div>
          <p className="font-bold text-xl text-[#001A46] dark:text-light">
            ویرایش کد تخفیف
          </p>
          <div className="flex items-center mt-4">
            <span className="w-[25%] h-0.5 bg-secondary-default dark:bg-primary-200"></span>
            <span className="w-[75%] h-0.5 bg-dark/[7%] dark:bg-[#4A4A4A]"></span>
          </div>
        </div>
        <EditDiscountForm setIsOpen={setIsOpen} discountData={discountData} />
      </div>

      <div
        className="absolute w-full h-full z-40"
        onClick={() => {
          setIsOpen(false);
        }}
      ></div>
    </div>
  );
}
