import { Button } from "@/components/ui/button";
import React, { Dispatch, SetStateAction } from "react";

type DevDeleteModalProps = {
  setIsOpenModal: Dispatch<SetStateAction<boolean>>;
  msg: string;
};

export default function ShowMsgModal({
  setIsOpenModal,
  msg,
}: DevDeleteModalProps) {
  return (
    <div className="fixed inset-0 flex items-center justify-center mx-auto w-screen h-screen overflow-hidden animate-fadeIn z-50">
      <div className="w-[350px] md:w-[400px] p-3 bg-light dark:bg-dark-400 rounded-10 z-50">
        <div>
          <p className="font-bold text-base text-[#001A46] dark:text-light">
            پیام کاربر
          </p>
          <div className="flex items-center mt-4">
            <span className="w-[20%] h-0.5 bg-secondary-default dark:bg-primary-200"></span>
            <span className="w-[80%] h-0.5 bg-dark/[7%] dark:bg-[#4A4A4A]"></span>
          </div>
        </div>
        <p className="my-3.5 ">{msg}</p>
        <div className="flex-center gap-2.5 w-full py-2">
          <Button
            className="inline-block flex-center h-8 px-5 bg-error-400 hover:bg-error-400/90 text-base text-light hover:text-light rounded"
            variant="outline"
            onClick={() => {
              setIsOpenModal(false);
            }}
          >
            بستن
          </Button>
        </div>
      </div>

      <div
        className="absolute w-full h-full z-40"
        onClick={() => {
          setIsOpenModal(false);
        }}
      ></div>
    </div>
  );
}
