"use client";

import { ContactMsgType } from "@/@types/contact";
import LoadingBox from "@/components/modules/LoadingBox";
import { Button } from "@/components/ui/button";
import { getAdminContactUs } from "@/services/contact";
import { useQuery } from "@tanstack/react-query";
import React, { useState } from "react";
import ShowMsgModal from "./ShowMsgModal";
import ContactUsMsgDeleteModal from "./ContactUsMsgDeleteModal";

export default function ContactUsMessageTable() {
  const [isOpenShowModal, setIsOpenShowModal] = useState<boolean>(false);
  const [isOpenDeleteModal, setIsOpenDeleteModal] = useState<boolean>(false);
  const [msgText, setMsgText] = useState<string>("");
  const [msgId, setMsgId] = useState<string>("");

  const { data: messages, isLoading } = useQuery({
    queryKey: ["admin-contact-us"],
    queryFn: getAdminContactUs,
    select: (res) => res.data,
  });
  if (isLoading) return <LoadingBox />;
  return (
    <>
      <table className="w-full mt-7">
        <thead>
          <tr className="child:text-right child:text-[#454545] dark:child:text-light/80 child:text-sm">
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              نام و نام خانوادگی
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              ایمیل
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              شماره تماس
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              تاریخ ارسال
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              مشاهده پیام
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              عملیات
            </th>
          </tr>
        </thead>
        <tbody className="divide-y divide-dark/[7%] dark:divide-light/[6%]">
          {messages?.contacts?.map((msg: ContactMsgType) => (
            <tr
              key={msg._id}
              className=" child:py-[30px] child:px-2 child:text-right child:grow child:w-[175px]"
            >
              <td>
                <p className="w-[175px] text-center text-[#575757] dark:text-light/80 text-sm">
                  {msg?.fullname}
                </p>
              </td>
              <td>
                <p className="w-[175px] text-center text-[#575757] dark:text-light/80 text-sm text-wrap break-all leading-6">
                  {msg?.email}
                </p>
              </td>
              <td>
                <p className="text-center text-[#575757] dark:text-light/80 text-sm">
                  {msg?.phone}
                </p>
              </td>
              <td>
                <p className="text-center text-[#575757] dark:text-light/80 text-sm">
                  {new Date(msg?.createdAt)?.toLocaleDateString("fa-IR")}
                </p>
              </td>

              <td className="!max-w-[80px]">
                <Button
                  className={`flex-center  w-[70px] p-2.5 bg-secondary-default hover:bg-secondary-default/90 duration-150 text-white text-xs mx-auto rounded-md`}
                  onClick={() => {
                    setIsOpenShowModal(true);
                    setMsgText(msg?.message);
                  }}
                >
                  مشاهده
                </Button>
              </td>
              <td className="!max-w-[80px]">
                <Button
                  className={`flex-center  w-[70px] p-2.5 bg-error-400 hover:bg-errors/90 duration-150 text-white text-xs mx-auto rounded-md`}
                  onClick={() => {
                    setIsOpenDeleteModal(true);
                    setMsgId(msg._id);
                  }}
                >
                  حذف
                </Button>
              </td>
            </tr>
          ))}
        </tbody>
      </table>

      {isOpenShowModal && (
        <ShowMsgModal setIsOpenModal={setIsOpenShowModal} msg={msgText} />
      )}

      {isOpenDeleteModal && (
        <ContactUsMsgDeleteModal
          setIsOpenDeleteModal={setIsOpenDeleteModal}
          msgId={msgId}
        />
      )}
    </>
  );
}
