"use client";
import { CommentsAdminType } from "@/@types/comment";
import LoadingBox from "@/components/modules/LoadingBox";
import { getAdminComments } from "@/services/comment";
import { useQuery } from "@tanstack/react-query";
import Image from "next/image";
import Link from "next/link";
import React from "react";

export default function CommentsByProducts() {
  const { data: comments, isLoading } = useQuery({
    queryKey: ["admin-comments"],
    queryFn: getAdminComments,
    select: (res) => res.data,
  });

  if (isLoading) return <LoadingBox />;

  return (
    <table className="w-full mt-7">
      <thead>
        <tr className=" child:text-[#454545] dark:child:text-light/80 child:text-sm">
          <th className="pb-3.25 border-b border-dark/[7%] dark:border-light/[6%]">
            محصول
          </th>
          <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
            تاریخ ایجاد
          </th>
          <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
            تاریخ ویرایش
          </th>
          <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
            تعداد کامنت ها
          </th>

          <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
            مشاهده
          </th>
        </tr>
      </thead>
      <tbody className="divide-y divide-dark/[7%] dark:divide-light/[6%]">
        {comments?.data?.map((comment: CommentsAdminType) => (
          <tr
            key={comment._id}
            className=" child:py-[30px] child:px-2 child:text-right child:grow child:min-w-[150px] lg:child:w-[15%]"
          >
            <td>
              <div className="flex items-center gap-2 xl:gap-[18px]">
                <Image
                  className="size-[55px] rounded-9 shrink-0"
                  src={`${process.env.NEXT_PUBLIC_BASE_URL}${comment?.fileid?.images[0]}`}
                  width={55}
                  height={55}
                  alt={comment?.fileid?.title ?? "عکس محصول"}
                />
                <p className="text-[#575757] dark:text-light/80 text-sm shrink-0">
                  {comment?.fileid?.title}
                </p>
              </div>
            </td>
            <td>
              <p className="text-[#575757] dark:text-light/80 text-base text-center">
                {new Date(comment?.createdAt)?.toLocaleDateString("fa-IR")}
              </p>
            </td>
            <td>
              <p className="text-[#575757] dark:text-light/80 text-base text-center">
                {new Date(comment?.createdAt)?.toLocaleDateString("fa-IR")}
              </p>
            </td>
            <td>
              <p className="text-[#575757] dark:text-light/80 text-base text-center">
                {comment?.comments?.length}
              </p>
            </td>
            <td className="">
              <Link
                href={`/admin-panel/comments/${comment?._id}`}
                className={`flex-center p-2.5 duration-150 text-white text-xs mx-auto rounded-md bg-secondary-default hover:bg-secondary-default/90`}
              >
                مشاهده
              </Link>
            </td>
          </tr>
        ))}
      </tbody>
    </table>
  );
}
