"use client";

import LoadingBox from "@/components/modules/LoadingBox";
import { getAdminBanks } from "@/services/bank";
import { useQuery } from "@tanstack/react-query";
import Link from "next/link";
import React from "react";

type UserInfoType = {
  username: string;
  email: string;
  codemeli: string;
  fname: string;
  lname: string;
  gender: "مرد" | "زن";
  datebirth: string;
  avatar: string;
  phone: string;
};

export default function BanksTable() {
  const { data: banks, isLoading } = useQuery({
    queryKey: ["admin-banks"],
    queryFn: () => getAdminBanks(),
    select: (res) => res.data,
  });
  if (isLoading) return <LoadingBox />;
  return (
    <table className="w-full mt-7">
      <thead>
        <tr className="child:text-right child:text-[#454545] dark:child:text-light/80 child:text-sm">
          <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
            نام
          </th>
          <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
            نام خانوادگی
          </th>
          <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
            موبایل
          </th>
          <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
            کد ملی
          </th>

          <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
            جزئیات
          </th>
        </tr>
      </thead>
      <tbody className="divide-y divide-dark/[7%] dark:divide-light/[6%]">
        {banks?.data.map(
          (item: { _id: string; banks: []; userid: UserInfoType }) => (
            <tr
              key={item._id}
              className=" child:py-[30px] child:px-2 child:text-right child:grow child:w-[175px]"
            >
              <td>
                <p className="text-center text-[#575757] dark:text-light/80 text-sm">
                  {item.userid.fname}
                </p>
              </td>
              <td>
                <p className="text-center text-[#575757] dark:text-light/80 text-sm text-wrap break-all leading-6">
                  {item.userid.lname}
                </p>
              </td>
              <td>
                <p className="text-center text-[#575757] dark:text-light/80 text-sm">
                  {item.userid.phone}
                </p>
              </td>
              <td>
                <p className="text-center text-[#575757] dark:text-light/80 text-sm">
                  {item.userid.codemeli}
                </p>
              </td>
              <td className="!max-w-[80px]">
                <Link
                  className={`flex-center  w-[70px] p-2.5 bg-secondary-default hover:bg-secondary-default/90 duration-150 text-white text-xs mx-auto rounded-md`}
                  href={`/admin-panel/banks/${item._id}`}
                >
                  مشاهده
                </Link>
              </td>
            </tr>
          )
        )}
      </tbody>
    </table>
  );
}
