import React from "react";
import Image from "next/image";
import { file } from "@/@types/file";
import Link from "next/link";

type ShopCardProps = {
  productData: file;
};

export default function ShopCard({ productData }: ShopCardProps) {
  return (
    <>
      <div className="mt-2.5 shrink-0">
        <Link href={`/products/${productData?.title}/${productData?.uid}`}>
          <Image
            src={process.env.NEXT_PUBLIC_BASE_URL + productData?.images[0]}
            width={240}
            height={240}
            alt={productData?.title}
            className="!w-[130px] !h-[130px] lg:!w-[240px] lg:!h-[220px] shrink-0 rounded-9"
          />
        </Link>
      </div>
      <Link href={`/products/${productData?.title}/${productData?.uid}`}>
        <p className="w-full my-3.5 lg:my-2.5 text-right text-[#081035] dark:text-[#EEEEEE] text-base font-peyda font-bold">
          {productData?.title}
        </p>
      </Link>
      <div className="flex items-start justify-start gap-1 w-full mt-3.5 font-bold text-primary-700">
        <p className="leading-none">{productData?.Score}</p>
        <svg className="size-4">
          <use href="#star"></use>
        </svg>
      </div>
      <div className="flex items-center justify-between mt-4 mb-[31px] w-full child:font-peyda child:text-[#081035]">
        <div className="flex-center p-2 lg:p-[13px] bg-light-200 dark:bg-dark-200 hover:bg-light-300 hover:dark:bg-dark-300 duration-150 cursor-pointer rounded-9 lg:rounded-full">
          <Link href={`/products/${productData?.title}/${productData?.uid}`}>
            <svg className="size-[26px] text-[#081035] dark:text-[#EEEEEE]">
              <use href="#shop"></use>
            </svg>
          </Link>
        </div>
        <div className="dark:text-[#EEEEEE]">
          <p className="font-bold text-lg">
            {productData?.price?.toLocaleString()}{" "}
            <span className="font-light">تومان</span>
          </p>
        </div>
      </div>
    </>
  );
}
