"use client";

import { useEffect } from "react";
import { useNetworkStatus } from "./useNetworkStatus";
import CustomToast from "./CustomToast";

export default function NetworkAlert() {
  const isOnline = useNetworkStatus();

  useEffect(() => {
    if (!isOnline) {
      CustomToast({ type: "error", text: "اتصال اینترنت قطع شده است!" });
    }
  }, [isOnline]);

  return null;
}
