import { BlogType } from "@/@types/blog";
import Link from "next/link";
import React from "react";

type LatestBlogTitleBoxProps = {
  blogData: null | BlogType;
};

export const LatestBlogTitleBox = ({ blogData }: LatestBlogTitleBoxProps) => {
  if (!blogData) return;
  return (
    <div className="flex items-center justify-between w-[350px] md:w-[391px] h-20 p-[22px] border border-[#CFD2E3] dark:border-[#616161] rounded-32">
      <p className="line-clamp-1">{blogData?.title}</p>
      <Link
        href={`/blogs/${blogData?.href}`}
        className="flex-center w-12 h-12  bg-[#ECFAEE] dark:bg-[#6A6A6A] text-success-100 dark:text-light rounded-18"
      >
        <svg className="size-[35px]">
          <use href="#arrow"></use>
        </svg>
      </Link>
    </div>
  );
};
