"use client";
import { BlogType } from "@/@types/blog";
import { getBlogs } from "@/services/blog";
import { useQuery } from "@tanstack/react-query";
import Link from "next/link";
import React from "react";

export default function FooterLatesBlogs() {
  const { data: blogs } = useQuery({
    queryKey: ["blogs"],
    queryFn: () => getBlogs(),
    select: (res) => res?.data?.blogs,
  });

  return (
    <div>
      <h4 className="font-bolds text-base-mines md:text-xl text-[#33323B] dark:text-light-200">
        آخرین مقالات
      </h4>
      <ul className="mt-[27px] child:mb-2.5">
        {blogs?.slice(0, 6)?.map((blog: BlogType) => (
          <li
            className="group  max-w-[190px] child:text-neutral-200 child:dark:text-light cursor-pointer"
            key={blog?._id}
          >
            <Link
              href={`/blogs/${blog?.href}`}
              className="flex items-center gap-4 w-full line-clamp-1"
            >
              <svg className="w-1.5 h-4 text-neutral-200 group-hover:text-primary-200 shrink-0">
                <use href="#chevron-left"></use>
              </svg>
              <p className="text-xs md:text-sm group-hover:text-primary-200 line-clamp-1">
                {blog?.title}
              </p>
            </Link>
          </li>
        ))}
      </ul>
      <Link href={"/blogs"} className="flex items-end gap-3 mt-[32px]">
        <p className="text-xs-mines md:text-base font-bold text-[#081035] dark:text-primary-200">
          مشاهده همه مقالات
        </p>
        <svg className="w-2.5 md:w-3.5 h-3 md:h-4 text-[#081035] dark:text-primary-200">
          <use href="#left-arrow"></use>
        </svg>
      </Link>
    </div>
  );
}
