import { toast } from "sonner";

type CustomToastProps = {
  type: "success" | "error" | "warning" | "info";
  text: string;
  des?: string;
};

export default function CustomToast({ type, text, des }: CustomToastProps) {
  if (type === "success") {
    return toast.success(text, { description: des });
  } else if (type === "error") {
    return toast.error(text, { description: des });
  } else if (type === "warning") {
    return toast.warning(text, { description: des });
  } else if (type === "info") {
    return toast.info(text, { description: des });
  } else {
    return toast(text, { description: des });
  }
}
