import { CommentType } from "@/@types/comment";
import { formatToPersianDate } from "@/lib/utils";
import React from "react";
import AnswerComment from "./AnswerComment";

type CommentBoxType = {
  data: CommentType & { answers: CommentType[] };
  onReply: (id: string) => void;
};

export default function CommentBox({ data, onReply }: CommentBoxType) {
  return (
    <div className="py-[26px] border-t border-dark/10 dark:border-light/[15%]">
      <div className="flex items-center justify-between">
        <div className="flex items-center">
          {/* <Image
            src="/images/comment-img.png"
            alt="عکس نظرات"
            width={50}
            height={50}
            className="w-[50px] h-[50px] rounded-full object-cover"
          /> */}
          <svg className="size-[50px] text-muted-foreground/20">
            <use href="#user-circle"></use>
          </svg>
          <div className="mr-[18px]">
            <p className="font-bold text-dark dark:text-light text-base">
              {data?.userid?.fname
                ? `${data?.userid?.fname} ${data?.userid?.lname}`
                : "کاربر"}
            </p>
            <p className="mt-0.75 text-dark/50 dark:text-light/50 text-sm-mines">
              {formatToPersianDate(data?.createdAt)}
            </p>
          </div>
        </div>
        {/* <div className="flex items-center gap-[21px]">
          <div className="flex items-center gap-[18px]">
            <div className="flex items-center gap-1.5">
              <span className="text-dark/50 dark:text-light/50 text-base-mines">
                11
              </span>
              <svg className="size-3.25 mb-0.5">
                <use href="#disLike"></use>
              </svg>
            </div>
            <div className="flex items-center gap-1.5">
              <span className="text-dark/50 dark:text-light/50 text-base-mines">
                2
              </span>
              <svg className="size-3.25 mb-1">
                <use href="#like"></use>
              </svg>
            </div>
          </div>
          <div className="flex items-center gap-1">
            <span className="text-base-mines text-dark dark:text-light">
              4.5
            </span>
            <svg className="size-[21px] mb-1 text-[#FFB800]">
              <use href="#star-outline"></use>
            </svg>
          </div>
        </div> */}
        <div className="flex items-center gap-[21px]">
          <div
            className="flex-center size-7 p-1 text-secondary-default hover:bg-secondary-default/10 rounded-full border border-secondary-default duration-150 cursor-pointer"
            onClick={() => onReply(data?._id)}
          >
            <svg className="size-6">
              <use href="#arrow-uturn-left"></use>
            </svg>
          </div>
        </div>
      </div>
      <p className="w-full mt-[17px] text-[#3F3F3F] dark:text-[#D3D3D3] text-justify left-8 text-wrap break-all">
        {data?.text}
      </p>
      {data?.answers.length > 0 &&
        data?.answers.map((item: CommentType) => (
          <AnswerComment key={item?._id} data={item} />
        ))}
    </div>
  );
}
