"use client";
import { CategoryType } from "@/@types/categorey";
import Link from "next/link";
import React, { Dispatch, SetStateAction, useState } from "react";

type CategoryLinkBoxProps = {
  category: CategoryType;
  setIsOpenSidebar: Dispatch<SetStateAction<boolean>>;
};

export default function CategoryLinkBox({
  category,
  setIsOpenSidebar,
}: CategoryLinkBoxProps) {
  const [isOpen, setIsOpen] = useState<boolean>(false);

  const clickHandler = () => {
    setIsOpenSidebar(false);
    setIsOpen(false);
  };

  return (
    <li className="mx-2" key={category._id}>
      <div className="flex items-center justify-between gap-1.5">
        <Link
          className={`text-sm font-bold duration-150 ${
            isOpen ? "text-primary-700" : ""
          }`}
          href={`/category/${category?.title}/${category?._id}`}
          onClick={() => setIsOpenSidebar(false)}
        >
          {category.title}
        </Link>
        {category.subcategories.length > 0 && (
          <svg
            className={`size-3 ${
              isOpen ? "-rotate-90 text-primary-700 duration-150" : ""
            }`}
            onClick={() => setIsOpen((prev) => !prev)}
          >
            <use href="#chevron-left"></use>
          </svg>
        )}
      </div>
      {category.subcategories.length > 0 && isOpen && (
        <ul className="p-3 my-2 bg-neutral-100/30 dark:bg-neutral-100/10 space-y-2 rounded-10">
          {category.subcategories?.map((item) => (
            <li key={item._id}>
              <Link
                className="text-sm hover:text-secondary-default duration-150"
                href={`/category/${category?.title}/${category?._id}/${item?.title}/${item?._id}`}
                onClick={clickHandler}
              >
                {item.title}
              </Link>
            </li>
          ))}
        </ul>
      )}
    </li>
  );
}
