import { BlogType } from "@/@types/blog";
import Image from "next/image";
import Link from "next/link";
import React from "react";

type BlogCardProps = { data: BlogType };

export default function BlogCard({ data }: BlogCardProps) {
  return (
    <div className="p-4 bg-light dark:bg-[#393939] rounded-14 shadow-sm">
      <div className="">
        <Link href={`/blogs/${data?.href}`}>
          <Image
            src={process.env.NEXT_PUBLIC_BASE_URL + data?.img}
            alt="عکس وبلاگ"
            width={147}
            height={147}
            className="w-full mx-auto rounded-10"
          />
        </Link>
      </div>
      <Link href={`/blogs/${data?.href}`}>
        <p className="h-[56px] mt-6 font-peyda font-bold text-lg text-dark-800 dark:text-light line-clamp-2">
          {data.title}
        </p>
      </Link>
      <div className="flex items-center gap-0.75 mt-2.25 text-[#FFA700]">
        <p className="font-peyda font-bold text-base">{666}</p>
        <svg className="size-[15px] ">
          <use href="#star"></use>
        </svg>
      </div>
      <div className="flex items-center justify-between mt-4 w-full child:font-peyda child:text-[#081035]">
        <Link
          href={`blogs/${data.href}`}
          className="flex-center gap-1 w-full p-2 bg-secondary-default hover:bg-secondary-default/80 duration-150 cursor-pointer rounded-9 child:text-light"
        >
          <p>مشاهده وبلاگ</p>
          <svg className="size-4 ">
            <use href="#left-arrow"></use>
          </svg>
        </Link>
      </div>
    </div>
  );
}
