import { file } from "@/@types/file";
import Image from "next/image";
import Link from "next/link";
import React from "react";

type BestProductCardProps = {
  data: file;
};

export default function BestProductCard({ data }: BestProductCardProps) {
  return (
    <div className="px-4 py-[21px] h-full bg-light dark:bg-[#393939] rounded-14 shadow-sm">
      <div className="">
        <div className=" flex-center w-[56px] py-1 mr-auto bg-[#6DA975]/20 dark:bg-[#DEDEDE]/20 rounded-18">
          <p className="flex-center w-[48px] py-1 bg-dark-800 dark:bg-[#666666] text-light font-peyda font-bold text-base rounded-14">
            30%
          </p>
        </div>
        <Link href={`/products/${data.title}/${data.uid}`}>
          <Image
            src={
              data?.images
                ? process.env.NEXT_PUBLIC_BASE_URL + data?.images[0]
                : "/images/product1.png"
            }
            alt="عکس محصول"
            width={147}
            height={147}
            className="w-[147px] h-[147px] mt-2.75 mx-auto rounded-10"
          />
        </Link>
      </div>
      <Link href={`/products/${data.title}/${data.uid}`}>
        <p className="mt-6 font-medium text-base text-dark-800 dark:text-light">
          {data.title}
        </p>
      </Link>
    </div>
  );
}
