import { CommentType } from "@/@types/comment";
import { formatToPersianDate } from "@/lib/utils";
import React from "react";

export default function AnswerComment({ data }: { data: CommentType }) {
  return (
    <div className="p-3 my-2.5 lg:mx-2.5 bg-muted-foreground/10 rounded-10">
      <div className="flex items-center justify-between">
        <div className="flex items-center">
          {/* <Image
                src="/images/comment-img.png"
                alt="عکس نظرات"
                width={50}
                height={50}
                className="w-[50px] h-[50px] rounded-full object-cover"
              /> */}
          <svg className="size-[50px] text-muted-foreground/20">
            <use href="#user-circle"></use>
          </svg>
          <div className="mr-[18px]">
            <p className="font-bold text-dark dark:text-light text-base">
              {data?.userid?.fname
                ? `${data?.userid?.fname} ${data?.userid?.lname}`
                : "کاربر"}
            </p>
            <p className="mt-0.75 text-dark/50 dark:text-light/50 text-sm-mines">
              {formatToPersianDate(data?.createdAt)}
            </p>
          </div>
        </div>

        <div className="flex items-center gap-[21px]"></div>
      </div>
      <p className="w-full mt-[17px] text-[#3F3F3F] dark:text-[#D3D3D3] text-justify text-wrap break-words left-8">
        {data?.text}
      </p>
    </div>
  );
}
