import React from "react";

import { cookies } from "next/headers";
import { redirect } from "next/navigation";
import UserLayoutHeader from "../userLayout/UserLayoutHeader";
import AdminPanelSidebar from "./AdminLayoutSidebar";

export default async function AdminPanelLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  try {
    const token = cookies().get("accessToken")?.value;
    const res = await fetch(`${process.env.NEXT_PUBLIC_BASE_URL}user/profile`, {
      method: "GET",
      headers: {
        "Content-Type": "application/json",
        authorization: `Bearer ${token ? token : ""}`,
      },
    });
    const adminInfo = await res.json();
    if (res?.ok !== true || adminInfo.user.role !== "ADMIN") {
      redirect("/");
    }
  } catch {
    redirect("/");
  }

  return (
    <main className="bg-[#F7F7FD] dark:bg-dark-200 h-full pt-[39px] pb-[98px]">
      <div className="flex items-start gap-[22px] px-2.5 md:px-[34px]  mx-auto">
        <AdminPanelSidebar />
        <section className="flex flex-col items-center justify-center w-full lg:w-[71%]">
          <UserLayoutHeader />
          {children}
        </section>
      </div>
    </main>
  );
}
