import React from "react";

import TicketsDetailsCard from "@/components/modules/TicketsDetailsCard";
import UserPanelLayout from "@/components/userLayout/UserPanelLayout";
import TicketsTable from "@/components/templates/userPanel/tickets/TicketsTable";
import Link from "next/link";
import { cookies } from "next/headers";
import { redirect } from "next/navigation";

export default async function TicketsPage() {
  const token = cookies().get("accessToken")?.value;
  const res = await fetch(`${process.env.NEXT_PUBLIC_BASE_URL}user/ticket`, {
    method: "GET",
    headers: {
      authorization: `Bearer ${token ? token : ""}`,
    },
    cache: "no-cache",
  });
  const tickets = await res.json();
  if (res.ok !== true) {
    redirect("/");
  }
  return (
    <UserPanelLayout>
      <section className="flex flex-wrap items-center gap-1.75 w-full mt-10">
        <TicketsDetailsCard
          text=" تیکت های باز :"
          value={tickets?.tiketopen}
          link="#"
        />
        <TicketsDetailsCard
          text=" تیکت های پاسخ داده شده :"
          value={tickets?.tiketopen}
          link="#"
        />
        <TicketsDetailsCard
          text=" تیکت های بسته شده :"
          value={tickets?.tiketclose}
          link="#"
        />
        <Link
          href="tickets/newTicket"
          className="flex-center grow md:grow-0 w-[247px] h-[54px] px-5 bg-secondary-default hover:bg-secondary-default/90 text-base text-white rounded"
        >
          ارسال تیکیت جدید
        </Link>
      </section>
      <section className="w-full mt-3 py-5 px-2 md:px-[35px] bg-light dark:bg-[#393939] border border-[#EBEBEB] dark:border-neutral-500/50 rounded-md">
        <div>
          <p className="font-bold text-xl text-[#001A46] dark:text-light">
            تیکیت ها
          </p>
          <div className="flex items-center mt-4">
            <span className="w-[8%] h-0.5 bg-secondary-default dark:bg-primary-200"></span>
            <span className="w-[92%] h-0.5 bg-dark/[7%] dark:bg-[#4A4A4A]"></span>
          </div>
        </div>
        <div className="w-full overflow-x-auto scrollbar-custom">
          <TicketsTable tickets={tickets?.data} />
        </div>
      </section>
    </UserPanelLayout>
  );
}
