import React from "react";
import UserPanelLayout from "@/components/userLayout/UserPanelLayout";
import DiscountBox from "@/components/modules/DiscountBox";
import UserShopInfo from "@/components/modules/UserShopInfo";
import { cookies } from "next/headers";

export default async function UserDashboard() {
  const token = cookies().get("accessToken")?.value;
  const res = await fetch(`${process.env.NEXT_PUBLIC_BASE_URL}user/profile`, {
    method: "GET",
    headers: {
      authorization: `Bearer ${token ? token : ""}`,
    },
  });
  const profileData = await res.json();

  return (
    <UserPanelLayout>
      <div className="grid grid-cols-1 md:grid-cols-2  gap-4 w-full mt-[22px]">
        <DiscountBox
          color="bg-secondary-default"
          title="تخفیف ویژه مخصوص شما"
          desc="برترین محصولات و فایل های دیجیتال"
          textColor="text-light"
          link="/products"
        />
        <DiscountBox
          color="bg-[#FDEC01]"
          title="برترین محصولات"
          desc="برترین محصولات و فایل های دیجیتال"
          textColor="text-dark"
          link="/products"
        />
      </div>
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-2 w-full mt-[25px]">
        <UserShopInfo
          icon="userPanel-box"
          title="تعداد خرید ها"
          value={profileData?.order}
          url="/user-panel/downloads"
        />
        <UserShopInfo
          icon="userPanel-box"
          title="تعداد زیر مجموعه ها"
          value={profileData?.ref}
          url="/user-panel/sales"
        />
        <UserShopInfo
          icon="userPanel-box2"
          title="تیکت های باز"
          value={profileData?.ticket}
          url="/user-panel/tickets"
        />
        <UserShopInfo
          icon="userPanel-box3"
          title="درآمد شما"
          price={String(profileData?.income)}
          url="/user-panel/sales"
        />
      </div>
    </UserPanelLayout>
  );
}
