import AddDiscountForm from "@/components/templates/userPanel/dev/discount/AddDiscountForm";
import DiscountTable from "@/components/templates/userPanel/dev/discount/DiscountTable";
import UserPanelLayout from "@/components/userLayout/UserPanelLayout";
import { cookies } from "next/headers";
import Link from "next/link";
import { redirect } from "next/navigation";
import React from "react";

export default async function page() {
  let discount = null;
  try {
    const token = cookies().get("accessToken")?.value;
    const res = await fetch(
      `${process.env.NEXT_PUBLIC_BASE_URL}user/discounts/list`,
      {
        method: "GET",
        headers: {
          authorization: `Bearer ${token ? token : ""}`,
        },
      }
    );
    discount = await res.json();
    if (res.ok !== true) {
      redirect("/");
    }
  } catch {
    redirect("/");
  }
  return (
    <UserPanelLayout>
      <section className="w-full mt-3 py-5 px-2 md:px-[35px] bg-light dark:bg-[#393939] border border-[#EBEBEB] dark:border-neutral-500/50 rounded-md">
        <div>
          <div className="flex items-center justify-between">
            <p className="font-bold text-xl text-[#001A46] dark:text-light">
              ایجاد کد تخفیف
            </p>
            <Link
              className="flex items-center gap-2.5 px-5 py-2.5 bg-secondary-default hover:bg-secondary-default/90 duration-150 child:text-white rounded-md"
              href="/user-panel/developers"
            >
              <p>بازگشت</p>
              <svg className="size-4">
                <use href="#left-arrow"></use>
              </svg>
            </Link>
          </div>
          <div className="flex items-center mt-4">
            <span className="w-[8%] h-0.5 bg-secondary-default dark:bg-primary-200"></span>
            <span className="w-[92%] h-0.5 bg-dark/[7%] dark:bg-[#4A4A4A]"></span>
          </div>
        </div>
        <div>
          <AddDiscountForm />
        </div>
      </section>
      <section className="w-full mt-3 py-5 px-2 md:px-[35px] bg-light dark:bg-[#393939] border border-[#EBEBEB] dark:border-neutral-500/50 rounded-md">
        <div>
          <p className="font-bold text-xl text-[#001A46] dark:text-light">
            لیست کد تخفیف ها
          </p>

          <div className="flex items-center mt-4">
            <span className="w-[8%] h-0.5 bg-secondary-default dark:bg-primary-200"></span>
            <span className="w-[92%] h-0.5 bg-dark/[7%] dark:bg-[#4A4A4A]"></span>
          </div>
        </div>
        {discount && discount.item.length > 0 && (
          <div className="w-full overflow-x-auto scrollbar-custom">
            <DiscountTable />
          </div>
        )}
      </section>
    </UserPanelLayout>
  );
}
