import Link from "next/link";
import { redirect } from "next/navigation";
import React from "react";

type PaymentResultsProps = {
  searchParams: Record<string, string | string[] | undefined>;
};
export default function PaymentResults({ searchParams }: PaymentResultsProps) {
  if (!searchParams.status) {
    return redirect("/");
  }
  return (
    <section className="w-full">
      <div className="p-5 my-20 mx-auto md:w-[67%] bg-light-200/50 dark:bg-dark-500 border border-[#F2F2F2] dark:border-[#F2F2F2]/30 rounded-10">
        {searchParams?.status === "success" ? (
          <div className="flex flex-col items-center justify-center">
            <svg className="size-16 text-success-400">
              <use href="#check-badge"></use>
            </svg>
            <p className="mt-4 text-2xl font-bold text-success-400">
              تراکنش موفق
            </p>
          </div>
        ) : (
          <div className="flex flex-col items-center justify-center">
            <svg className="size-16 text-error-300">
              <use href="#x-circle-solid"></use>
            </svg>
            <p className="mt-4 text-2xl font-bold text-error-300">
              تراکنش ناموفق
            </p>
          </div>
        )}
        {searchParams?.status === "success" ? (
          <div className="w-1/2 mt-3 mx-auto border-t border-[#F2F2F2] dark:border-[#F2F2F2]/5">
            <div className="flex items-start justify-center mt-4 child:font-bold child:text-xl">
              <p>مبلغ پرداخت شده:</p>
              <p className="mr-2">
                {searchParams?.amount
                  ? ` ${Number(searchParams?.amount)?.toLocaleString()} تومان`
                  : "مبلغی ثبت نشده است"}
              </p>
            </div>
          </div>
        ) : null}

        <div className="flex justify-center mt-4">
          <Link
            className="inline-block my-2.5  bg-secondary-default text-white p-2.5 rounded-md"
            href="/products"
          >
            بازگشت به فروشگاه
          </Link>
        </div>
      </div>
    </section>
  );
}
