import type { Metadata } from "next";
import localFont from "next/font/local";
import "./globals.css";
import { Index as Header } from "@/components/modules/layout/Index";
import { SVGIcons } from "@/components/modules/SVGIcons";
import { QueryClientProviders } from "@/components/modules/QueryClientProviders";
import { Toaster } from "sonner";
import UserProvider from "./context/UserProvider";
import OrderCountProvider from "./context/OrderCountProvider";
import ShowSidebarContext from "./context/ShowSidebarContext";
import NetworkAlert from "@/components/modules/NetworkAlert";
import GlobalLoadingHandler from "@/components/modules/GlobalLoading";

const peydaFont = localFont({
  variable: "--font-peyda",
  src: [
    {
      path: "../../public/fonts/PeydaWebFaNum-Thin.woff2",
      weight: "100",
      style: "normal",
    },
    {
      path: "../../public/fonts/PeydaWebFaNum-ExtraLight.woff2",
      weight: "200",
      style: "normal",
    },
    {
      path: "../../public/fonts/PeydaWebFaNum-Light.woff2",
      weight: "300",
      style: "normal",
    },
    {
      path: "../../public/fonts/PeydaWebFaNum-Regular.woff2",
      weight: "400",
      style: "normal",
    },
    {
      path: "../../public/fonts/PeydaWebFaNum-Medium.woff2",
      weight: "500",
      style: "normal",
    },
    {
      path: "../../public/fonts/PeydaWebFaNum-SemiBold.woff2",
      weight: "600",
      style: "normal",
    },
    {
      path: "../../public/fonts/PeydaWebFaNum-Bold.woff2",
      weight: "700",
      style: "normal",
    },
    {
      path: "../../public/fonts/PeydaWebFaNum-ExtraBold.woff2",
      weight: "800",
      style: "normal",
    },
    {
      path: "../../public/fonts/PeydaWebFaNum-Black.woff2",
      weight: "900",
      style: "normal",
    },
  ],
});
const yekanBakhFont = localFont({
  variable: "--font-yekanbakh",
  src: [
    {
      path: "../../public/fonts/YekanBakhFaNum-Thin.woff2",
      weight: "100",
      style: "normal",
    },
    {
      path: "../../public/fonts/YekanBakhFaNum-Light.woff2",
      weight: "300",
      style: "normal",
    },
    {
      path: "../../public/fonts/YekanBakhFaNum-Regular.woff2",
      weight: "400",
      style: "normal",
    },
    {
      path: "../../public/fonts/YekanBakhFaNum-SemiBold.woff2",
      weight: "600",
      style: "normal",
    },
    {
      path: "../../public/fonts/YekanBakhFaNum-Bold.woff2",
      weight: "700",
      style: "normal",
    },
    {
      path: "../../public/fonts/YekanBakhFaNum-ExtraBold.woff2",
      weight: "800",
      style: "normal",
    },
    {
      path: "../../public/fonts/YekanBakhFaNum-ExtraBlack.woff2",
      weight: "900",
      style: "normal",
    },
    {
      path: "../../public/fonts/YekanBakhFaNum-Black.woff2",
      weight: "900",
      style: "normal",
    },
  ],
});

export const metadata: Metadata = {
  title: "دارکوبیت | فروش فایل ‌و محصولات دانلودی",
  description: "سایت دارکوبیت | darkoobit",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="fa" dir="rtl" className="">
      <body
        className={`bg-light dark:bg-dark-200 ${peydaFont.variable} ${yekanBakhFont.variable} antialiased `}
      >
        <QueryClientProviders>
          <UserProvider>
            <OrderCountProvider>
              <ShowSidebarContext>
                <NetworkAlert />
                <GlobalLoadingHandler />
                <Header>
                  {children}
                  <SVGIcons />
                </Header>
              </ShowSidebarContext>
              <Toaster richColors />
            </OrderCountProvider>
          </UserProvider>
        </QueryClientProviders>
      </body>
    </html>
  );
}
