"use client";

import { OrderItemType } from "@/@types/order";
import React, { createContext, ReactNode, useEffect, useState } from "react";

type OrderContextType = {
  orderCount: number;
  setOrderCount: React.Dispatch<React.SetStateAction<number>>;
  localDate: OrderItemType[] | [];
  setLocalDate: React.Dispatch<React.SetStateAction<OrderItemType[] | []>>;
};

export const OrderCountContext = createContext<OrderContextType | null>(null);

export default function OrderCountProvider({
  children,
}: {
  children: ReactNode;
}) {
  const [orderCount, setOrderCount] = useState<number>(0);
  const [localDate, setLocalDate] = useState<OrderItemType[] | []>([]);

  useEffect(() => {
    const localData = localStorage.getItem("orders");
    const data: OrderItemType[] = localData ? JSON.parse(localData) : [];

    setLocalDate(data);
  }, []);

  useEffect(() => {
    if (localDate.length < 0) return;
    const count = localDate.reduce((acc, cur) => acc + cur.count, 0);
    setOrderCount(count);
  }, [localDate]);

  return (
    <OrderCountContext.Provider
      value={{ orderCount, setOrderCount, localDate, setLocalDate }}
    >
      {children}
    </OrderCountContext.Provider>
  );
}
