export type UserInfoType = {
  username: string;
  email: string;
  codemeli: string;
  fname: string;
  lname: string;
  gender: "مرد" | "زن";
  datebirth: string;
  avatar: string;
};

export type UserAddressType = {
  website: string;
  homephone: string;
  postalcode: string;
  city: string;
  province: string;
  phone: string;
  address: string;
};

export type userInfoAdminType = {
  attempts: string;
  date: string;
  email: string;
  fname: string;
  invitation: string;
  lname: string;
  phone: string;
  refcode: string;
  status: string;
  username: string;
  _id: string;
  wallet: string;
  address?: string;
  city?: string;
  codemeli?: string;
  datebirth?: string;
  gender?: string;
  homephone?: string;
  postalcode?: string;
  province?: string;
  website?: string;
  isAuthentication: boolean;
  isflag: boolean;
  isdev: boolean;
  password: string;
  role: "USER" | "ADMIN" | "SEO";
};

export type EditUserFormType = {
  username: string;
  fname: string;
  lname: string;
  phone: string;
  codemeli: string;
  email: string;
  address: string;
  password: string;
  gender: string;
  datebirth: string;
  website: string;
  homephone: string;
  postalcode: string;
  province: string;
  city: string;
  isAuthentication: boolean;
  isflag: boolean;
  isdev: boolean;
  role: "USER" | "ADMIN" | "SEO";
};

export type AddUserType = {
  username: string;
  fname: string;
  lname: string;
  phone: string;
  codemeli: string;
  email: string;
  address: string;
  role: "USER";
  wallet: number;
  gender: "male" | "female";
  datebirth: string;
  website: string;
  homephone: string;
  postalcode: string;
  province: string;
  city: string;
  isdev: boolean;
  password: string;
};
