import { StatusType } from "./status";

export type CommentsType = {
  _id: string;
  fileid: {
    _id: string;
    title: string;
  };
  comments: {
    userid: {
      email: string;
      fname: string;
      lname: string;
      phone: string;
      role: string;
      username: string;
      _id: string;
    };
    text: string;
    answers: [];
    status: StatusType;
    isapproved: boolean;
    _id: string;
    createdAt: string;
  }[];
};

export type CommentType = {
  createdAt: string;
  isapproved: boolean;
  status: StatusType;
  text: string;
  is_page_show?: boolean;

  userid: {
    email: string;
    fname: string;
    lname: string;
    phone: string;
    role: string;
    username: string;
    _id: string;
  };
  _id: string;
};

export type CommentsAdminType = {
  comments: {
    _id: string;
    createdAt: string;
    is_page_show?: boolean;
    isapproved: boolean;
    status: StatusType;
    text: string;
    userid: {
      email: string;
      fname: string;
      lname: string;
      phone: string;
      role: string;
      username: string;
      _id: string;
    };
  }[];
  createdAt: string;
  fileid: {
    title: string;
    _id: string;
    images: string[];
  };
  is_page_show?: boolean;
  updatedAt: string;
  _id: string;
};
